/*
COPYRIGHT INFORMATION:
This free script was written by Daniel Rodney - instructor, graphic designer
Adobe Certified Expert
Adobe Certified Instructor
No part of this script can be used and/or redistributed as your own.
All rights are reserved by Daniel Rodney.
http://www.danrodney.com
dan@danrodney.com
Copyright Daniel Rodney 2005-2007

DESCRIPTION:
This script is meant to provide a fast way to convert numerous typographer's quotes (smart quotes) 
into foot and inch marks all at once. I hope you find it useful and a time saver.

You can share this script with friends and associates as long as it does not involve posting 
it on a website or other medium where it can be downloaded/shared with many people. 
Any form of mass distribution is prohibited unless you obtain prior written consent. 
Please direct people to http://www.danrodney.com to download it.

Thanks Dan!
If you find this "free" script valuable, please consider making a donation via PayPal. It will:
- Encourage me to write more free scripts.
- Make you (and me) feel warm and fuzzy inside.
- Be a great way to say thanks for the hours I spent writing a script that saved you some time and effort.
Just visit http://www.danrodney.com/scripts
Go to the Quotes to Foot & Inch Marks page and click the Make A Donation button. Thanks!

COMPATIBILITY:
This script works on both Mac and PC. It has been tested in InDesign/InCopy CS3.

INSTRUCTIONS - INSTALLING THE SCRIPT:
To install the script, put the script file (has a .jsx file extension) into the folder listed below. 
(InCopy installations are identical to InDesign, except the desired folder is titled InCopy.)

CS3: Mac-----------------------------------------------------------
Hard Drive > Applications > Adobe InDesign CS3 > Scripts > Scripts Panel
or Hard Drive > Users > [username] > Library > Preferences > Adobe InDesign > Version 5.0 > Scripts > Scripts Panel

CS3: Windows XP-----------------------------------------------------------
C:Drive > Program Files > Adobe > Adobe InDesign CS3 > Scripts > Scripts Panel 
or C:Drive > Documents and Settings > [username] > Application Data > Adobe > InDesign > Version 5.0 > Scripts > Scripts Panel

CS3: Windows Vista-----------------------------------------------------------
C:Drive > Program Files > Adobe > Adobe InDesign CS3 > Scripts > Scripts Panel
or C:Drive > Users > [username] > AppData > Roaming > Adobe > InDesign > Version 5.0 > Scripts > Scripts Panel

INSTRUCTIONS - USING THE SCRIPT:
1. Select some text that contains typographers quotes you would like to change into foot/inch marks.
2. Double-click this script's name in the Scripts panel.
          NOTE: To find the Scripts panel go into the Window menu and choose Automation > Scripts.
That's it! I hope you enjoy... 


==================================================================================================  */

//start of the actual script

//define function to reuse whenever they don't haven't the proper text selected
function myQuoteTextNotSelectedAlert()
{
	alert("Please select some text that contains quotes you would like to convert.\nScript written by Daniel Rodney - instructor, graphic designer\nwww.danrodney.com");
}

if (app.documents.length == 0) //make sure a document is open
{
	//no documents are open, so display an error message
	alert("You don't have any InDesign documents open. Please open a document and select some text that contains quotes you would like to convert.\nScript written by Daniel Rodney - instructor, graphic designer\nwww.danrodney.com");
}
else if (app.selection.length == 0) //make sure something is selected
{
	//nothing is selected, so display an error message
	myQuoteTextNotSelectedAlert();
}
else if (app.selection.length > 1) //make sure only one thing is selected
{
	//more than one thing is selected, so display an error message
	alert("Please select only one text frame that contains quotes you would like to convert.\nScript written by Daniel Rodney - instructor, graphic designer\nwww.danrodney.com");
}
else if (app.selection[0].constructor.name == "InsertionPoint") //make sure text is selected
{
	//no text is selected, so display an error message
	myQuoteTextNotSelectedAlert();
}
else if (app.selection[0].contents == undefined) //make sure it's text that is selected
{
	//nothing is selected, so display an error message
	myQuoteTextNotSelectedAlert();
}
else
{	
	//find out the current document's Typographers Quote Preference
	userOriginalQuotePreference = app.activeDocument.textPreferences.typographersQuotes

	//turn off the Typographers preference
	app.activeDocument.textPreferences.typographersQuotes = false
	
	//set Find/Change preferences to nothing, in case the user had left settings on a previous search
	app.findTextPreferences = NothingEnum.nothing
	app.changeTextPreferences = NothingEnum.nothing

	//====================== PERFORM SEARCHES  ======================
	//change left double quote into inch mark
	app.findTextPreferences.findWhat = "\u201C"
	app.changeTextPreferences.changeTo = "\u0022"
	app.selection[0].changeText( )

	//change right double quote into inch mark
	app.findTextPreferences.findWhat = "\u201D"
	app.changeTextPreferences.changeTo = "\u0022"
	app.selection[0].changeText( )
	
	//change left single quote into foot mark
	app.findTextPreferences.findWhat = "\u2018"
	app.changeTextPreferences.changeTo = "\u0027"
	app.selection[0].changeText( )
	
	//change right single quote into foot mark  
	app.findTextPreferences.findWhat = "\u2019"
	app.changeTextPreferences.changeTo = "\u0027"
	app.selection[0].changeText( )

	//reset Typographers Quote Preference back to the users original setting
	app.activeDocument.textPreferences.typographersQuotes = userOriginalQuotePreference
}